load("manifesto-counts.RData")
library(parallel)

mtn.smpl <- function(P,N){

  n <- length(N)
  stopifnot(nrow(P)==n)

  dn <- dimnames(P)
    
  P <- memisc:::split.matrix(P,1:n)
  
  M <- mapply(rmultinom,n=1,size=N,prob=P)
  
  structure(t(M),dimnames=dn)
}

cmpboot.multinom <- function(expr,data,nsim=1){

  expr <- substitute(expr)

  vars <- all.vars(expr)
  syms <- lapply(vars, as.symbol)

  dframe <- manifesto.counts[21:131]
  matr <- as.matrix(dframe)

  denom <- rowSums(matr)
  probs <- matr/denom
  probs[denom==0,] <- 1/ncol(probs)

  res <- replicate(nsim,eval(expr,envir=data.frame(mtn.smpl(probs,denom)),enclos=parent.frame()))
  res
}

system.time(boot.rile <- cmpboot.multinom(
        (militpos + freedmhumrights  + constpos  + polauthority  + freeenterp  + incentives  +
         protcnsmneg  + econorthodox  +   welfarelimit  + natwaylifepos  + tradmoralpos  + laworder  +
         socialharmony)
        - (antiimp + militneg  + peace  + internatpos  + marketregul  +
            econplan  + protcnsmpos  + controlecon  + nationalize  + welfareexpand  + educexpand  +
            labourpos + democracy),
    manifesto.counts,
    nsim=5000))

save(boot.rile,file="boot-rile.RData")