library(memisc)
load("manifesto-counts.RData")
load("boot-logplaneco.RData")
load("boot-rile.RData")
load("boot-planeco.RData")
load("predict-econ-latpos.RData")
source("panel-bands.R")

bootuplo.logplaneco <- apply(boot.logplaneco,1,quantile, probs=c(.025,.975))
bootuplo.rile <- apply(boot.rile,1,quantile, probs=c(.025,.975))
bootuplo.planeco <- apply(boot.planeco,1,quantile, probs=c(.025,.975))

manifesto.counts <- within(manifesto.counts,{

        planeco <- 100*((freeenterp+econorthodox)-(marketregul+econplan+controlecon))/total

        logplaneco <-
          -log((
                  marketregul
                + econplan
                + controlecon
                + .5
            )
            /
            (
                  freeenterp
                + econorthodox
                +.5
            ))

        logplaneco.lwr <- bootuplo.logplaneco[1,]
        logplaneco.upr <- bootuplo.logplaneco[2,]

        rile.lwr <- 100*(bootuplo.rile[1,]/total)
        rile.upr <- 100*(bootuplo.rile[2,]/total)
        planeco.lwr <- 100*(bootuplo.planeco[1,]/total)
        planeco.upr <- 100*(bootuplo.planeco[2,]/total)
})

euro.pred.econ.latpos <- subset(pred.econ.latpos,
                                      partyname %in% c(
                                        "Conservative Party",
                                        "Right Party",
                                        "MSP Moderate Coalition Party",
                                        "Moderate Coalition Party (The Alliance  Manifest)",
                                        "Moderate Coalition Party (Alliance Jobmanifesto)",
                                        "H Conservative Party",
                                        "KF Conservative People's Party",
                                        "VVD People's Party for Freedom and Democracy",
                                        "Gaullists",
                                        "RPR Rally for the Republic",
                                        "UMP Union for the Presidential Majority",
                                        "UMP Union for a Popular Movement",
                                        "AP Popular Alliance",
                                        "PP Popular Party",
                                        "CDU/CSU Christian Democratic Union/Social Union",
                                        "SdaP Social Democratic Labour Party",
                                        "DNA Labour Party",
                                        "SD Social Democratic Party",
                                        "PvdA Labour Party",
                                        "SIFO Socialist Party",
                                        "PS Socialist Party",
                                        "PSOE Socialist Workers' Party",
                                        "Partido Socialista Obrero Espa",
                                        "SPD Social Democratic Party",
                                        "Labour Party"
                                        )
                                    & countryname %in% c(
                                        "Sweden",
                                        "Netherlands",
                                        "France",
                                        "Spain",
                                        "Germany",
                                        "Great Britain"
                                      )
                                    )




euro.pred.econ.latpos <- within(euro.pred.econ.latpos,{
  countryname <- recode(countryname,
                        "Great Britain" -> "United Kingdom",
                        otherwise="copy"
                        )
  countryname <- factor(countryname)
  countryname <- factor(countryname,levels=sort(levels(countryname)))
  ConsLab <- recode(partyname,
                    c(
                      "Conservative Party",
                      "Right Party",
                      "MSP Moderate Coalition Party",
                      "Moderate Coalition Party (The Alliance  Manifest)",
                      "Moderate Coalition Party (Alliance Jobmanifesto)",
                      "H Conservative Party",
                      "KF Conservative People's Party",
                      "VVD People's Party for Freedom and Democracy",
                      "Gaullists",
                      "RPR Rally for the Republic",
                      "UMP Union for the Presidential Majority",
                      "UMP Union for a Popular Movement",
                      "AP Popular Alliance",
                      "PP Popular Party",
                      "CDU/CSU Christian Democratic Union/Social Union"
                      ) -> "Conservative",
                    c(
                      "SdaP Social Democratic Labour Party",
                      "DNA Labour Party",
                      "SD Social Democratic Party",
                      "PvdA Labour Party",
                      "SIFO Socialist Party",
                      "PS Socialist Party",
                      "PSOE Socialist Workers' Party",
                      "Partido Socialista Obrero Espa",
                      "SPD Social Democratic Party",
                      "Labour Party"
                    ) -> "Social democrat"
                    ) 
})



euro.manifesto.counts <- subset(manifesto.counts,
                                      partyname %in% c(
                                        "Conservative Party",
                                        "Right Party",
                                        "MSP Moderate Coalition Party",
                                        "Moderate Coalition Party (The Alliance  Manifest)",
                                        "Moderate Coalition Party (Alliance Jobmanifesto)",
                                        "H Conservative Party",
                                        "KF Conservative People's Party",
                                        "VVD People's Party for Freedom and Democracy",
                                        "Gaullists",
                                        "RPR Rally for the Republic",
                                        "UMP Union for the Presidential Majority",
                                        "UMP Union for a Popular Movement",
                                        "AP Popular Alliance",
                                        "PP Popular Party",
                                        "CDU/CSU Christian Democratic Union/Social Union",
                                        "SdaP Social Democratic Labour Party",
                                        "DNA Labour Party",
                                        "SD Social Democratic Party",
                                        "PvdA Labour Party",
                                        "SIFO Socialist Party",
                                        "PS Socialist Party",
                                        "PSOE Socialist Workers' Party",
                                        "Partido Socialista Obrero Espa",
                                        "SPD Social Democratic Party",
                                        "Labour Party"
                                        )
                                    & countryname %in% c(
                                        "Sweden",
                                        "Netherlands",
                                        "France",
                                        "Spain",
                                        "Germany",
                                        "Great Britain"
                                      )
                                    )




euro.manifesto.counts <- within(euro.manifesto.counts,{
  countryname <- recode(countryname,
                        "Great Britain" -> "United Kingdom",
                        otherwise="copy"
                        )
  countryname <- factor(countryname)
  countryname <- factor(countryname,levels=sort(levels(countryname)))
  ConsLab <- recode(partyname,
                    c(
                      "Conservative Party",
                      "Right Party",
                      "MSP Moderate Coalition Party",
                      "Moderate Coalition Party (The Alliance  Manifest)",
                      "Moderate Coalition Party (Alliance Jobmanifesto)",
                      "H Conservative Party",
                      "KF Conservative People's Party",
                      "VVD People's Party for Freedom and Democracy",
                      "Gaullists",
                      "RPR Rally for the Republic",
                      "UMP Union for the Presidential Majority",
                      "UMP Union for a Popular Movement",
                      "AP Popular Alliance",
                      "PP Popular Party",
                      "CDU/CSU Christian Democratic Union/Social Union"
                      ) -> "Conservative",
                    c(
                      "SdaP Social Democratic Labour Party",
                      "DNA Labour Party",
                      "SD Social Democratic Party",
                      "PvdA Labour Party",
                      "SIFO Socialist Party",
                      "PS Socialist Party",
                      "PSOE Socialist Workers' Party",
                      "Partido Socialista Obrero Espa",
                      "SPD Social Democratic Party",
                      "Labour Party"
                    ) -> "Social democrat"
                    )
})



library(lattice)
library(latticeExtra)

bwtheme <- simpleTheme(
                        col=c(rep("black",6),"gray60"),
                        col.points=c(rep("black",6),"gray60"),
                        lwd=2,
                        lty=c(2,1,3:6),
                        pch=15:20
                        )

bwtheme$strip.background <- list(alpha=1,col="white")
bwtheme$strip.shingle <- list(alpha=1,col="gray75")

econlr.plt <- xyplot(econlr~edate|countryname, data = euro.pred.econ.latpos,
       groups=ConsLab,
       type="l",
       par.settings=simpleTheme(
         col="black",
         lty=c(1,2),
         pch=c(19,15)
       ),
       xlab="Election date",
       ylab="Economic policy position",
       as.table=TRUE
)

econlr.bandplt <- xyplot(cbind(econlr.lwr,econlr.upr)~edate|countryname, 
                         data = euro.pred.econ.latpos,
                         groups=ConsLab,
                         type="l",
                         par.settings=simpleTheme(
                           col="black",
                           lty=c(1,2),
                           pch=c(19,15)
                         ),
                         xlab="Election date",
                         ylab="Economic policy position",
                         panel=panel.bands,
                         band.col=c("gray75","gray75"),
                         as.table=TRUE
)

econlr.plt <- econlr.plt + as.layer(econlr.bandplt,under=TRUE)
econlr.plt <- update(econlr.plt,
                     layout=c(3,2),
                     aspect=1,
                     scales=list(
                       x=list(alternating=1,tck=c(1,0)),
                       y=list(alternating=1,tck=c(1,0))
                     ),
                     auto.key=list(lines=TRUE,points=FALSE,columns=2),
                     par.settings=bwtheme)

plot(econlr.plt)

cairo_pdf(file="conslab-euro-plot.pdf",width=15,height=8,bg="transparent")
print(econlr.plt)
dev.off()

cairo_ps(file="conslab-euro-plot.eps",width=15,height=8,bg="transparent")
print(econlr.plt)
dev.off()



rile.plt <- xyplot(rile~edate|countryname, data = euro.manifesto.counts,
       groups=ConsLab,
       type="l",
       par.settings=simpleTheme(
         col="black",
         lty=c(1,2),
         pch=c(19,15)
       ),
       xlab="Election date",
       ylab="CMP RiLe",
       as.table=TRUE
)

rile.bandplt <- xyplot(cbind(rile.lwr,rile.upr)~edate|countryname,
                         data = euro.manifesto.counts,
                         groups=ConsLab,
                         type="l",
                         par.settings=simpleTheme(
                           col="black",
                           lty=c(1,2),
                           pch=c(19,15)
                         ),
                         xlab="Election date",
                         ylab="Economic policy position",
                         panel=panel.bands,
                         band.col=c("gray75","gray75"),
                         as.table=TRUE
)

rile.plt <- rile.plt + as.layer(rile.bandplt,under=TRUE)
rile.plt <- update(rile.plt,
                     layout=c(3,2),
                     aspect=1,
                     scales=list(
                       x=list(alternating=1,tck=c(1,0)),
                       y=list(alternating=1,tck=c(1,0))
                     ),
                     auto.key=list(lines=TRUE,points=FALSE,columns=2),
                     par.settings=bwtheme)

plot(rile.plt)

cairo_pdf(file="conslab-rile-euro-plot.pdf",width=15,height=8,bg="transparent")
print(rile.plt)
dev.off()

cairo_ps(file="conslab-rile-euro-plot.eps",width=15,height=8,bg="transparent")
print(rile.plt)
dev.off()


logplaneco.plt <- xyplot(logplaneco~edate|countryname, data = euro.manifesto.counts,
       groups=ConsLab,
       type="l",
       par.settings=simpleTheme(
         col="black",
         lty=c(1,2),
         pch=c(19,15)
       ),
       xlab="Election date",
       ylab="Lowe et al. LogPlanEco",
       as.table=TRUE
)

logplaneco.bandplt <- xyplot(cbind(logplaneco.lwr,logplaneco.upr)~edate|countryname,
                         data = euro.manifesto.counts,
                         groups=ConsLab,
                         type="l",
                         par.settings=simpleTheme(
                           col="black",
                           lty=c(1,2),
                           pch=c(19,15)
                         ),
                         xlab="Election date",
                         ylab="Economic policy position",
                         panel=panel.bands,
                         band.col=c("gray75","gray75"),
                         as.table=TRUE
)

logplaneco.plt <- logplaneco.plt + as.layer(logplaneco.bandplt,under=TRUE)
logplaneco.plt <- update(logplaneco.plt,
                     layout=c(3,2),
                     aspect=1,
                     scales=list(
                       x=list(alternating=1,tck=c(1,0)),
                       y=list(alternating=1,tck=c(1,0))
                     ),
                     auto.key=list(lines=TRUE,points=FALSE,columns=2),
                     par.settings=bwtheme)

plot(logplaneco.plt)

cairo_pdf(file="conslab-logplaneco-euro-plot.pdf",width=15,height=8,bg="transparent")
print(logplaneco.plt)
dev.off()

cairo_ps(file="conslab-logplaneco-euro-plot.eps",width=15,height=8,bg="transparent")
print(logplaneco.plt)
dev.off()


planeco.plt <- xyplot(planeco~edate|countryname, data = euro.manifesto.counts,
       groups=ConsLab,
       type="l",
       par.settings=simpleTheme(
         col="black",
         lty=c(1,2),
         pch=c(19,15)
       ),
       xlab="Election date",
       ylab="CMP PlanEco",
       ylim=c(-25,40),
       as.table=TRUE
)

planeco.bandplt <- xyplot(cbind(planeco.lwr,planeco.upr)~edate|countryname,
                         data = euro.manifesto.counts,
                         groups=ConsLab,
                         type="l",
                         par.settings=simpleTheme(
                           col="black",
                           lty=c(1,2),
                           pch=c(19,15)
                         ),
                         xlab="Election date",
                         ylab="Economic policy position",
                         panel=panel.bands,
                         band.col=c("gray75","gray75"),
                         as.table=TRUE
)

planeco.plt <- planeco.plt + as.layer(planeco.bandplt,under=TRUE)
planeco.plt <- update(planeco.plt,
                     layout=c(3,2),
                     aspect=1,
                     scales=list(
                       x=list(alternating=1,tck=c(1,0)),
                       y=list(alternating=1,tck=c(1,0))
                     ),
                     auto.key=list(lines=TRUE,points=FALSE,columns=2),
                     par.settings=bwtheme)

plot(planeco.plt)
cairo_pdf(file="conslab-planeco-euro-plot.pdf",width=15,height=8,bg="transparent")
print(planeco.plt)
dev.off()

cairo_ps(file="conslab-planeco-euro-plot.eps",width=15,height=8,bg="transparent")
print(planeco.plt)
dev.off()
