load("changes-econ-latpos.RData")
source("panel-bars.R")

FR.changes.econ.latpos <- subset(changes.econ.latpos,
                                 countryname=="France" & 
                                   partyname %in% c("SIFO Socialist Party",
                                                    "PS Socialist Party")
)

FR.changes.econ.latpos <- within(FR.changes.econ.latpos,{
  partyname <- recode(partyname,
                      c("SIFO Socialist Party",
                      "PS Socialist Party")->"France: Socialist Party"
                      )
  partyname <- factor(partyname)
})

UK.changes.econ.latpos <- subset(changes.econ.latpos,
  countryname=="Great Britain" & partyname == "Labour Party"
)

UK.changes.econ.latpos <- within(UK.changes.econ.latpos,{
  partyname <- recode(partyname,
                      "Labour Party" -> "UK: Labour Party")
  partyname <- factor(partyname)
})

library(lattice)
library(latticeExtra)


bwtheme <- simpleTheme(
                        col="black",lwd=1.5,lty=c(1,2,4)
                        )

bwtheme$strip.background <- list(alpha=1,col="white")
bwtheme$strip.shingle <- list(alpha=1,col="gray75")

FR.econlr.plt <- xyplot(econlr~as.factor(edate)|partyname, data = FR.changes.econ.latpos,
                        type="p",
                        par.settings=bwtheme,
                        #panel=panel.vbars,
                        pch=19,
                        xlab="Election date",
                        ylab="Economic L/R position shift",
                        ylim=c(-1.9,1.9),
                        scales=list(
                          x=list(alternating=1,tck=c(1,0),rot=90),
                          y=list(tck=c(1,0))
                        ),
                        aspect=1
)

FR.econlr.barplt <- 
  xyplot(cbind(econlr.lwr,econlr.upr)~as.factor(edate)|partyname, data = FR.changes.econ.latpos,
         type="l",
         par.settings=bwtheme,
         panel=function(x,y,...){
           panel.vbars(x,y,width=.5,col="gray75",border=NA,...)
           panel.abline(h=0,lty=1)
         }
  )

UK.econlr.plt <- xyplot(econlr~as.factor(edate)|partyname, data = UK.changes.econ.latpos,
       type="p",
       par.settings=bwtheme,
       #panel=panel.vbars,
       pch=19,
       xlab="Election date",
       ylab="Economic L/R position shift",
       ylim=c(-1.9,1.9),
       scales=list(
          x=list(alternating=1,tck=c(1,0),rot=90),
          y=list(tck=c(1,0))
          ),
       aspect=1
       )


UK.econlr.barplt <- 
xyplot(cbind(econlr.lwr,econlr.upr)~as.factor(edate)|partyname, data = UK.changes.econ.latpos,
       type="l",
       par.settings=bwtheme,
       panel=function(x,y,...){
            panel.vbars(x,y,width=.5,col="gray75",border=NA,...)
            panel.abline(h=0,lty=1)
          }
       )
       
(FR.plt <- FR.econlr.plt + as.layer(FR.econlr.barplt,under=TRUE))
(UK.plt <- UK.econlr.plt + as.layer(UK.econlr.barplt,under=TRUE))

(plt <- c(FR.plt, UK.plt))

pdf(file="FRUK-econlr-shifts-plot.pdf",width=7.5,height=5,bg="transparent")
print(plt)
dev.off()

postscript(file="FRUK-econlr-shifts-plot.eps",width=7.5,height=5,bg="transparent",horizontal=FALSE)
print(plt)
dev.off()