rm(list=ls())
library(manifestos)
load(file="manifesto-counts.RData")
options(error=recover)
options(latpos.chunk.size=4*1024*1024)
if(.Platform$GUI=="X11")
  X11.options(width=12,height=7)


econ.latpos <- latpos(
   nationalize+controlecon+econplan+marketregul+incentives+econorthodox+freeenterp~econlr,
   data=manifesto.counts,
   id=party,
   time=year*100 + month,
   free.beta=TRUE,
   initial.size=50,
   maxiter=1000,
   force.increase=TRUE,
   Q.linesearch=TRUE
 )
save(econ.latpos,file="econ-latpos.RData")
summary(econ.latpos)
