rm(list=ls())
library(manifestos)
load(file="manifesto-counts.RData")
options(error=recover)
options(latpos.chunk.size=2*1024*1024)

nonmat.latpos <- latpos(
    laworder+tradmoralpos+tradmoralneg+natwaylifepos+
    democracy+freedmhumrights~authlib+tradmod,
    data=manifesto.counts,
    id=party,
    time=year*100 + month,
    initial.size=50,
    max.size=7500,
    restrictions=set.parms.free(
      authlib=c("natwaylifepos","laworder","democracy","freedmhumrights"),
      tradmod=c("tradmoralpos","tradmoralneg","democracy","freedmhumrights")
    ),
    start = list(
          A=list(
              authlib=c(natwaylifepos=1.4,laworder=.7,democracy=-1),
              tradmod=c(tradmoralpos=1,tradmoralneg=-1)
            )
        ),
    force.increase=TRUE,
    Q.linesearch=TRUE
)
save(nonmat.latpos,file="nonmat-latpos.RData")
summary(nonmat.latpos)
