panel.vbars <- function(x,y,...,width=1){

  x <- as.numeric(x)
  y <- as.numeric(y)
  xunit <- diff(range(x))/length(unique(x))
  width <- width*xunit

  if(length(y)==2*length(x))
    Y <- matrix(y,ncol=2)
  else
    Y <- cbind(0,y)

  ybottom <- Y[,1]
  ytop <- Y[,2]

  xleft <- x - width/2
  xright <- x + width/2
  panel.rect(xleft=xleft,xright=xright,
             ybottom=ybottom,ytop=ytop,...)
}


