rm(list=ls())
library(manifestos)

load("econ-latpos.RData")
load("sim-econ-latpos.RData")
load("manifesto-counts.RData")

as.function.density <- function(x,rule=1,...){

  approxfun(x=x$x,y=x$y,rule=rule)
}

manifesto.id.data <- subset(manifesto.counts,
        select=c(countryname,year,month,day,partyname))

manifesto.id.data <- within(manifesto.id.data,
        id <- 1:nrow(manifesto.id.data))

use.Labour <- subset(manifesto.id.data,
        partyname=="Labour Party" & countryname == "Great Britain",
        select=c(id,year,month,day))

id.Labour.1964 <- unlist(subset(use.Labour,year==1964,select=id))
id.Labour.1997 <- unlist(subset(use.Labour,year==1997,select=id))

Labour.1964 <- sim.econ.latpos[id.Labour.1964,]
Labour.1997 <- sim.econ.latpos[id.Labour.1997,]

density.Labour.1964 <- density(Labour.1964)
density.Labour.1997 <- density(Labour.1997)

densfun.Labour.1964 <- as.function(density.Labour.1964)
densfun.Labour.1997 <- as.function(density.Labour.1997)

obj.locs <- econ.latpos$parm$A

obj.locs <- rowrename(obj.locs,
          freeenterp="Free enterprize",
          incentives="Incentives",
          marketregul="Market regulation",
          econplan="Economic planning",
          controlecon="Controlled economy",
          nationalize="Nationalization",
          econorthodox="Economic orthodoxy")
          
plotit <- function(upto=Inf){

  plot.new()
  plot.window(
    xlim=range(Labour.1964,Labour.1997,obj.locs),
    ylim=range(0,density.Labour.1964$y,density.Labour.1997$y,3.7)
    )
  axis(1,at=-2:2)
  mtext("Economic Left/Right",side=1,line=2)

  if(upto<=1) return(invisible())

  means <- c(mean(Labour.1964),mean(Labour.1997))
  density.Labour.1964.ci95 <- within.list(density.Labour.1964,{
                             lwr <- quantile(Labour.1964,.025)
                             upr <- quantile(Labour.1964,.975)
                             keep <- x>lwr & x < upr 
                             y <- y[keep]
                             x <- x[keep]
                             y <- c(0,y,0)
                             x <- c(x[1],x,x[length(x)])
  })
  density.Labour.1997.ci95 <- within.list(density.Labour.1997,{
    lwr <- quantile(Labour.1997,.025)
    upr <- quantile(Labour.1997,.975)
    keep <- x>lwr & x < upr 
    y <- y[keep]
    x <- x[keep]
    y <- c(0,y,0)
    x <- c(x[1],x,x[length(x)])
  })
  axis(2)
  box()
  mtext("Density",side=2,line=2)
  polygon(density.Labour.1964,col="gray90",border=NA)
  polygon(density.Labour.1964.ci95,col="gray60",border=NA)
  lines(density.Labour.1964)
  points(x=means[1],y=0,pch=19)
  polygon(density.Labour.1997,col="gray90",border=NA)
  polygon(density.Labour.1997.ci95,col="gray60",border=NA)
  lines(density.Labour.1997)
  points(x=means[2],y=0,pch=19)

  points(x=means[1],y=0,pch=19)
  segments(x0=means[1],x1=means[1],y0=0,y1=densfun.Labour.1964(means[1]),lty=2)
  text(x=means[1],y=densfun.Labour.1964(means[1]),labels="Position in 1964",pos=3)
  if(upto<=2) return(invisible())

  points(x=means[2],y=0,pch=19)
  segments(x0=means[2],x1=means[2],y0=0,y1=densfun.Labour.1997(means[2]),lty=2)
  text(x=means[2],y=densfun.Labour.1997(means[2]),labels="Position in 1997",pos=3)
  if(upto<=3) return(invisible())

  segments(
    x0=obj.locs,
    x1=obj.locs,
    y0=0,
    y1=.8
    )
  text(
    x=rep(obj.locs,length(obj.locs)),
    y=rep(.8,length(obj.locs))+.03,
    labels=rownames(obj.locs),
    adj=c(0,0.5),
    srt=90
  )

}

plotit()

pdf(file="labour-1964-1997.pdf",width=6,height=6,bg="transparent")
plotit()
dev.off()
postscript(file="labour-1964-1997.eps",width=6,height=6,bg="transparent",horizontal=FALSE)
plotit()
dev.off()
