library(memisc)
manifesto.data <- read.csv("../ManifestoProject/MPDataset_full.csv")

names(manifesto.data) <- tolower(names(manifesto.data))

lct <- Sys.getlocale("LC_TIME"); Sys.setlocale("LC_TIME", "C")

manifesto.data <- within(manifesto.data,{
  edate <- as.character(edate)
  edate <- as.Date(edate,format="%m/%d/%Y")
})

manifesto.data <- rename(manifesto.data,
    per101   = "frgnpos",
    per102   = "frgnneg",
    per103   = "antiimp",
    per104   = "militpos",
    per105   = "militneg",
    per106   = "peace",
    per107   = "internatpos",
    per108   = "eucompos",
    per109   = "internatneg",
    per110   = "eucomneg",
    per201   = "freedmhumrights",
    per202   = "democracy",
    per203   = "constpos",
    per204   = "constneg",
    per301   = "decentralize",
    per302   = "centralize",
    per303   = "goveffic",
    per304   = "polcorrupt",
    per305   = "polauthority",
    per401   = "freeenterp",
    per402   = "incentives",
    per403   = "marketregul",
    per404   = "econplan",
    per405   = "corporatism",
    per406   = "protcnsmpos",
    per407   = "protcnsmneg",
    per408   = "econgoals",
    per409   = "keynesianism",
    per410   = "productivity",
    per411   = "techinfrastr",
    per412   = "controlecon",
    per413   = "nationalize",
    per414   = "econorthodox",
    per415   = "marxistanalysis",
    per416   = "antigrowth",
    per501   = "environprot",
    per502   = "culture",
    per503   = "socialjustice",
    per504   = "welfareexpand",
    per505   = "welfarelimit",
    per506   = "educexpand",
    per507   = "educlimit",
    per601   = "natwaylifepos",
    per602   = "natwaylifeneg",
    per603   = "tradmoralpos",
    per604   = "tradmoralneg",
    per605   = "laworder",
    per606   = "socialharmony",
    per607   = "multicultpos",
    per608   = "multicultneg",
    per701   = "labourpos",
    per702   = "labourneg",
    per703   = "agriculture",
    per704   = "middleclass",
    per705   = "minorities",
    per706   = "nonecongroups",
    peruncod = "uncoded"
  )



save(manifesto.data,file="manifesto-data.RData")

manifesto.counts <- within(manifesto.data,{
  foreach(x=c(
    frgnpos,
    frgnneg,
    antiimp,
    militpos,
    militneg,
    peace,
    internatpos,
    eucompos,
    internatneg,
    eucomneg,
    freedmhumrights,
    democracy,
    constpos,
    constneg,
    decentralize,
    centralize,
    goveffic,
    polcorrupt,
    polauthority,
    freeenterp,
    incentives,
    marketregul,
    econplan,
    corporatism,
    protcnsmpos,
    protcnsmneg,
    econgoals,
    keynesianism,
    productivity,
    techinfrastr,
    controlecon,
    nationalize,
    econorthodox,
    marxistanalysis,
    antigrowth,
    environprot,
    culture,
    socialjustice,
    welfareexpand,
    welfarelimit,
    educexpand,
    educlimit,
    natwaylifepos,
    natwaylifeneg,
    tradmoralpos,
    tradmoralneg,
    laworder,
    socialharmony,
    multicultpos,
    multicultneg,
    labourpos,
    labourneg,
    agriculture,
    middleclass,
    minorities,
    nonecongroups,
    uncoded
    ),
    x <- as.integer(round(total*x/100))
    )
  year <- as.integer(format(edate,"%Y"))
  month <- as.integer(format(edate,"%m"))
  day <- as.integer(format(edate,"%d"))
})

save(manifesto.counts,file="manifesto-counts.RData")
Sys.setlocale("LC_TIME", lct)