sim.to.pred <- function(object,Usim,
                        se.fit=FALSE,
                        interval=c("none",
                                   "normal",
                                   "percentile"),
                        level=0.95){

      if(length(dim(Usim))<3)
        dim(Usim) <- c(dim(Usim)[1],1,dim(Usim)[2])

      latent.dims <- object$parm$latent.dims
      B <- as.matrix(rowMeans(Usim,dims=2))

      colnames(B) <- latent.dims
      if(se.fit || interval=="normal"){

            se.B <- t(sqrt(as.matrix(rowMeans(Usim^2,dims=2)) - B^2))
            colnames(se.B) <- latent.dims
      }
      if(se.fit){

        return(list(fit=B,se.fit=se.B))
      }
      if(interval=="normal") {

        res <- array(B,c(dim(B),3))

        zval <- qnorm((1 - level)/2)
        res[,,2] <- B + zval*se.B
        res[,,3] <- B - zval*se.B
        dimnames(res) <- list(dimnames(B)[[1]],latent.dims,c("fit","lwr","upr"))
        return(res)
      }
      else if(interval == "percentile"){

        res <- array(B,c(dim(B),3))
        prob <- (1 - level)/2
        prob <- c(prob,1-prob)
        B.lowup <- apply(Usim,c(1,2),quantile,probs=prob)
        B.lowup <- aperm(B.lowup,c(2,3,1))
        res[,,2:3] <- B.lowup
        dimnames(res) <- list(dimnames(B)[[1]],latent.dims,c("fit","lwr","upr"))
        return(res)
      }
      return(B)
}