options(error=recover)
set.seed(3)

alpha <- c(-1,-.5,-.1,.1,.5,1)

J <- 100
Tj <- rpois(n=J,lambda=10)

j <- 1:J
j <- j[Tj>0]
Tj <- Tj[Tj>0]
j <- rep(j,Tj)
t <- unlist(lapply(Tj,function(Tj)seq(from=1,to=Tj)))-1
N <- length(t)

beta <- .1
sigma0 <- 1
sigma1 <- .1
rho <- .9

t.j <- split(t,j)

u0 <- sort(rnorm(n=J,sd=sqrt(sigma0)))


b <- unlist(lapply(seq(along=t.j),function(i){

  t <- t.j[[i]]

  Tj <- length(t)
  Tj1 <- Tj-1
  u <- u0[i]
  if(Tj1){
    u1 <- rnorm(n=Tj1,sd=sqrt(sigma1))
    u <- c(u,u1)

    D <- diag(Tj)
    D[-1,-Tj] <- D[-1,-Tj] - rho*D[-Tj,-Tj]
    u <- solve(D,u)
  }
  u + beta
}))



dist.sq <- (outer(b,alpha,"-"))^2
p <- exp(-dist.sq/2)
p <- p/rowSums(p)

n <- rpois(n=N,lambda=20)

m <- t(sapply(1:N,function(i)rmultinom(n=1,prob=p[i,],size=n[i])))


perc <- 100*m/rowSums(m)

colnames(m) <- paste("count",1:ncol(m),sep="")
colnames(perc) <- paste("perc",1:ncol(perc),sep="")

simul.data <- data.frame(m,n,perc,j,t)

library(manifestos)

est <- latpos(
   count1+count2+count3+count4+count5+count6~lr,
   data=simul.data,
   id=j,
   time=t,
   initial.size=50,
   maxiter=1000,
   sampler=mvt.sampler(df=7),
   rel.diff.psi.eps=1e-2,
   diff.Q.eps=1e-7,
   diff.logLik.eps=1e-7,
   force.increase=FALSE,
   Q.linesearch=TRUE
 )

summary(est)

save(b,j,t,est,file="simul-model.RData")

