library(manifestos)
library(memisc)
load("econ-latpos.RData")

(A <- econ.latpos$parm$A)

(V <- econ.latpos$parm$covmat[1:7,1:7])

(Rmat0 <- t(c(rep(1,4)/4,rep(-1,3)/3)))

(Rmat1 <- as.matrix(bdiag(diff(diag(4)),matrix(0,nrow=0,ncol=3))))

(Rmat2 <- as.matrix(bdiag(matrix(0,nrow=0,ncol=4),diff(diag(3)))))

(R1.A <- Rmat1%*%A)

(R2.A <- Rmat2%*%A)

(Rmat1.a <- as.matrix(bdiag(diff(diag(3)),matrix(0,nrow=0,ncol=4))))

(Rmat2.a <- as.matrix(bdiag(matrix(0,nrow=0,ncol=5),diff(diag(2)))))

(R1a.A <- Rmat1.a%*%A)

(R2a.A <- Rmat2.a%*%A)

WaldTest <- function(A,R,V){

  RA <- R%*%A
  RVR <- R%*%tcrossprod(V,R)

  W <- drop(crossprod(RA,solve(RVR,RA)))
  df <- nrow(R)
  p <- pchisq(W,df=df,lower.tail=FALSE)

  data.frame(W,df,p)
}

Testtab <- rbind(
            WaldTest(A,Rmat0,V),
            WaldTest(A,Rmat1,V),
            WaldTest(A,Rmat2,V))

Testtab.a <- rbind(
            WaldTest(A,Rmat1.a,V),
            WaldTest(A,Rmat2.a,V))


Testtab <- colrename(Testtab,
                    W="$W$",
                    p="$\\Pr(\\chi^2>|W|)$")
rownames(Testtab) <- c(
                      "Mean difference between interventionist \\\\ and laissez-faire objectives",
                      "Variation among interventionist objectives",
                      "Variation among laissez-faire objectives"
                      )

writeLines(
  toLatex(Testtab,digits=c(1,0,3),ddigits=c(1,0,-1)),
  con="wald-test-econ.tex"
  )