Dummies <- function(x,...) UseMethod("Dummies")
setGeneric("Dummies",function(x,...)standardGeneric("Dummies"))

Dummies.default <- function(x,...){
    levs <- sort(unique(x))
    sapply(levs,function(lev)as.integer(x==lev))
}


Dummies.factor <- function(x,...){
    levs <- levels(x)
    sapply(levs,function(lev)as.integer(x==lev))
}

setMethod("Dummies","item.vector",function(x,labelled.only=TRUE,...){
    if(labelled.only){
        vl <- labels(x)
        ux <- vl@values
        names(ux) <- vl@.Data
    }
    else
        ux <- unique(x)
    missing.values <- missing.values(x)
    if(length(missing.values)){
        uxmiss <- is.missing2(ux,missing.values)
        ux <- ux[!uxmiss]
    }
    sapply(ux,function(ux)ifelse(is.missing(x),NA,as.integer(x==ux)))
})