scoretest <- function(formula,
    model,
    data,
    subset,
    weights,
    na.action=getOption("na.action"),
    contrasts=NULL,
    D=NULL) UseMethod("scoretest")

print.scoretest <- function(x, digits = max(getOption("digits") - 2, 3),
                        signif.stars = getOption("show.signif.stars"), ...){
    cat("\nBaseline model:\n")
    baseline <- x$null.model
    baseline$... <- NULL
    cat(paste(deparse(baseline), sep="\n", collapse="\n"), "\n", sep="")
    cat("\nScore test for",paste(x$tested))
    cat("\n\n")
    table <- as.matrix(x)
    printCoefmat(table,digits=digits,signif.stars=signif.stars,
                tst.ind=1,zap.ind=3,P.values=TRUE,has.Pvalue=TRUE)
    cat("\nModification indices:\n")
    print(drop(x$first.order))
    if(is.matrix(x$D)){
      cat("\nSpecial design matrix:\n")
        print(x$D)
    }
    cat("\n")
}

as.matrix.scoretest <- function(x) {
    pval <- pchisq(x$chisq,x$df,lower.tail=FALSE)
    table <- cbind(
            x$chisq,
            x$df,
            pval,
            x$N
            )
    colnames(table) <- c("Chisq","Df","Pr(>Chisq)","N")
    rownames(table) <- ""
    table
}
