\name{mlogit}
\alias{mlogit}
\alias{mlogit.fit}
\alias{mlogit.control}

\title{Multinomial Logit Models}
\description{
  \code{mlogit} fits multinomial logit models, using the same algorithm
  as \code{glm}, but adapted to a multi-column response. The response
  may be a factor, a matrix of binary data, or a matrix of counts.
}
\usage{
mlogit(formula, baseline=1, data, weights, subset, na.action,
      start = NULL, control=mlogit.control(...), model = TRUE,
      x = FALSE, y = TRUE, contrasts = NULL, ...)
      
mlogit.fit(X,Y,weights=rep(1,nobs),start=NULL,
      control=mlogit.control(),intercept=TRUE)

mlogit.control(epsilon = 1e-08, maxit = 100,
    optim.maxit=100, optim.tol = epsilon, trace = FALSE)
}
\arguments{
  \item{formula}{an object of class \code{"\link{formula}"} (or one that
    can be coerced to that class): a symbolic description of the
    model to be fitted.}

  \item{baseline}{an integer value or character string,
    identifying the baseline category of the response. Refers
    to a number or column name of the response matrix or a factor
    level of the response.}

  \item{data}{an optional data frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data frame) containing
    the variables in the model.  If not found in \code{data}, the
    variables are taken from \code{environment(formula)},
    typically the environment from which \code{glm} is called.}

  \item{weights}{an optional vector of weights to be used in the fitting
    process.  Should be \code{NULL} or a numeric vector.}

  \item{subset}{an optional vector specifying a subset of observations
    to be used in the fitting process.}

  \item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.  The default is set by
    the \code{na.action} setting of \code{\link{options}}, and is
    \code{\link{na.fail}} if that is unset.  The \sQuote{factory-fresh}
    default is \code{\link{na.omit}}.  Another possible value is
    \code{NULL}, no action.  Value \code{\link{na.exclude}} can be useful.}

  \item{start}{a matrix or vector of starting values for the coefficients;
    should be a matrix, with the same number of rows as the number of
    parameters per equation, and one column less than the number
    of levels of the response factor or the number of colums of
    the response matrix. If it is not already such a matrix it is
    coerced into one using \code{\link{matrix}(start,nrow=nvars,ncol=ncat)},
    where \code{nvars} is the number of independent variables and \code{ncat}
    is the number of categories of the response minus one.
  }

  \item{control}{a list of parameters for controlling the fitting
    process.}

  \item{model}{a logical value indicating whether \emph{model frame}
    should be included as a component of the returned value.}

  \item{x, y}{
    logical values indicating whether the response vector and model
    matrix used in the fitting process should be returned as components
    of the returned value.
  }

  \item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

  \item{\dots}{
    arguments to be passed by default to
    \code{mlogit.control}: see argument \code{control}.}
    

  \item{X}{a design matrix.}
  \item{Y}{a response matrix.}
  \item{intercept}{logical value, does X contain an intercept?}  
  \item{epsilon}{positive convergence tolerance \eqn{\epsilon};
    the iterations converge when
    \eqn{|dev - dev_{old}|/(|dev| + 0.1) < \epsilon}{|dev - devold|/(|dev| + 0.1) < \epsilon}.}
  \item{maxit}{integer giving the maximal number of IWLS iterations.}
  \item{optim.maxit}{integer giving the maximal number of iterations in \code{\link{optim}}.}
  \item{optim.tol}{numeric, giving the relative convergence tolerance of \code{\link{optim}}.}
  \item{trace}{logical indicating if output should be produced for each
    iteration.}
}
\value{
  \code{mlogit} returns an object of class "mlogit", which has almost the
  same structure as an object of class "\link[stats]{glm}". The difference are
  the components \code{coefficients}, \code{residuals}, \code{fitted.values},
  \code{linear.predictors}, and \code{y}, which are matrices with 
  number of columns equal to the number of response categories minus one.
}
\details{
  \code{mlogit} tries first to fit the model using the IRLS algorithm of
  \code{\link[stats]{glm.fit}}, which has the advantage that
  starting values are not needed in most cases. If convergence
  cannot achieved, it tries to minimize the deviance using
  \code{\link[stats]{optim}} with method "BFGS".
}
\examples{
(mlgt1 <- mlogit(Dept~Gender,data=UCBAdmissions,weights=Freq))
berkDept <- Aggregate(Table(Dept,Freq)~Gender,data=UCBAdmissions)
(mlgt2 <- mlogit(cbind(A,B,C,D,E,F)~Gender,data=berkDept))
summary(mlgt1)
anova(mlgt1)

berkeley <- Aggregate(Table(Admit,Freq)~.,data=UCBAdmissions)
glm(cbind(Admitted,Rejected)~Gender+Dept,data=berkeley,family="binomial")
mlogit(cbind(Admitted,Rejected)~Gender+Dept,data=berkeley,baseline="Rejected")
}
\keyword{models}
\keyword{regression}