## Users may need to install the corresponding packages before running the following
## lines, e.g. with:
# install.packages(c("memisc","magrittr"))

library(magrittr)
library(memisc)

std <- function(x) as.vector(scale(x))

macrodata <- read.csv("macrodata.csv")
macrodata %<>% within({
    gdpz    <- std(gdp)
    tenurez <- std(tenure)
    tradez  <- std(eutrade)
    inflz   <- std(infl)
    country <- factor(country,
                      labels = trimws(levels(country)))
})


ZA2898 <- Stata.file("ZA2898_v1-0-1.dta")
ZA2898.work <- subset(ZA2898,
                      v622 >= 18,
                      select=c(
                          v6,
                          v47,
                          v51,
                          v621,
                          age = v622,
                          v614,
                          income = v647,
                          v658)    
                      )
                      
ZA2898.work %<>% within({
    # Some values are labelled most are not
    measurement(age) <- "ratio"
    # Constructing the dept. var.
    v47 %<>% recode(
                 1   -> 1,
                 2:3 -> 0)
    support <- v47 + v51
    # Creating income quartile dummies
    # Low income
    inclow <- ifelse(income == 1, 1, 0)
    # High income
    inchi <- ifelse(income == 4, 1, 0)
    # Keeping only lavels for valid values
    labels(income) <- labels(income)[1:4]
    # Left-right self-placement
    lright <- v614 - 1
    # Opinion leader index, centered around sample mean
    olead <- v658 - mean(v658, na.rm=TRUE)
    # Male gender dummy
    male <- recode(v621,
                   1 -> 1,
                   2 -> 0)
    # Countries: Combine West- and East Germany
    country <- recode(v6,
                    Germany = 4 <- c(4,13),
                    otherwise = "copy")
    country %<>% as.character()
        # Keep only variables further needed
    retain(age, support, inclow, inchi, income, lright, olead, male, country)
})

ZA2898.work %<>% as.data.frame()

steenbergen_jones_data <- merge(ZA2898.work,
                                macrodata,
                                by="country")

steenbergen_jones_data %<>% within(
                                country <- factor(country)
                            )

save(steenbergen_jones_data,
     file="steenbergen-jones-data.RData")
