sink("steenbergen-jones-nlme.Rlog",split=TRUE)
load("steenbergen-jones-data.RData")
# Steenbergen and Jones example:
# Dependent variable is 
# 'support': the support for EU
# Independent variables are
# at country level:
#   'tenurez': Tenure within EU (standardized)
#   'tradez':  Within-EU trade (standardized)
#   'gdpz':    GDP per capita (standardized)
#   'inflz':   Inflation (standardized)
# at individual level
#   'inclow':  Dummy for lowest income quartile
#   'inchi':   Dummy for highest income quartile
#   'lright':  Left-right self-placement
#   'olead': Opinion leadership (centered)
#   'male': Male gender dummy
#   'age': Age

library(nlme)
# To select the ML estimator we have to explicitly ask for it, because
# REML is the default
sj.ml <- lme(support ~ tenurez + tradez + gdpz + inflz
                       + inclow + inchi + lright + olead + male + age,
             method = "ML",
             random = ~1 | country,
             na.action = na.exclude, # Deal with missing values
             data   = steenbergen_jones_data)
#
# The summary method already selects a Student's t-distribution for the
# p-values
summary(sj.ml)

# REML is the default, so we do not need to call it up
# explicitly 
sj.reml <- lme(support ~ tenurez + tradez + gdpz + inflz
                       + inclow + inchi + lright + olead + male + age,
             random = ~1 | country,
             na.action = na.exclude, # Deal with missing values
             data   = steenbergen_jones_data)
#
# The summary method already selects a Student's t-distribution for the
# p-values
summary(sj.reml)
sink()
