version 15.1

use data_replication, clear

// Hierarchical model, ML estimation
xtmixed support tenurez tradez gdpz inflz inclow inchi lright olead male age ||cntry:, mle var
est sto m1
est tab m1, b se
preserve
parmest, fast
gen estimator = "ML"
save "likelihood_estimates.dta", replace
restore


xtmixed support tenurez tradez gdpz inflz inclow inchi lright olead male age ||cntry:, reml var
est sto m1
est tab m1, b se
parmest, fast
gen estimator = "REML"
append using "likelihood_estimates.dta"
compress
saveold "likelihood_estimates.dta", replace version(12)

