library(tidyverse)
library(ggplot2)
library(stringr)
library(foreign)

# Define working directory
loc <- "YOURPATH/ReplicationFiles/EmpApplication_Replication/"

(estimates <- read.dta(str_c(loc, "likelihood_estimates.dta")) %>%
  filter(parm == "tenurez" | parm == "tradez" | parm == "gdpz" | parm == "inflz") %>%
  mutate(
    min95MminL = estimate - qt(0.975, df = 9) * stderr,
    max95MminL = estimate + qt(0.975, df = 9) * stderr) %>%
  select(parm, estimate, min95, max95, estimator, min95MminL, max95MminL) %>%
  rbind(readRDS(str_c(loc, "bayesMCMC_estimates.rds"))) %>%
  mutate(
    parm = recode_factor(factor(parm),
      "inflz"   = "Inflation",
      "gdpz"    = "GDP",
      "tenurez" = "Tenure",
      "tradez"  = "Trade",
      .ordered  = TRUE)))

# Plot the results
(plot <- ggplot(data = estimates, aes(y = estimate, x = parm, ymin = min95, ymax = max95)) +
  geom_hline(yintercept = 0, lty = 'solid', size = 0.4, color = "black") +
  geom_linerange(aes(ymin = min95MminL, ymax = max95MminL, fill = estimator), color = "black", size = 0.7, position = position_dodge(width = 0.4)) +
  geom_linerange(aes(fill = estimator), size = 2, color = "#808080", position = position_dodge(width = 0.4)) +
  geom_point(aes(fill = estimator), shape = 21, size = 4, position = position_dodge(width = 0.4)) +
  scale_fill_manual("",
      values = c("white", "black", "gray"),
      label = c("Bayesian", "ML", "REML")) +
  coord_flip() +
  scale_x_discrete("") +
  scale_y_continuous("Point estimate and 95% confidence interval", breaks = c(-1, -0.5, 0, 0.5, 1)) +
  #scale_y_continuous("Point Estimate and 95% Confidence Interval", breaks = c(-1, -0.5, 0, 0.5, 1)) +
  theme_bw() +
    theme(panel.grid.minor = element_line(colour="white"),
    legend.justification= c(0, 0.8),
    legend.box = "vertical",
    legend.background = element_rect(fill=NA, color=NA),
    legend.key        = element_rect(fill =NA, color =NA),
    strip.background = element_rect(fill = "#f1f1f1", color = NA)) +
    theme(legend.position=c(0, 1)))

ggsave(filename = str_c(loc,"Figure5_bw.pdf"), plot = plot, width = 7.5, height = 4.5)

(plot <- ggplot(data = estimates, aes(y = estimate, x = parm, ymin = min95, ymax = max95)) +
  geom_hline(yintercept = 0, lty = 'solid', size = 0.4, color = "#FFA500") +
  geom_linerange(aes(ymin = min95MminL, ymax = max95MminL, fill = estimator), color = "red", size = 0.7, position = position_dodge(width = 0.4)) +
  geom_linerange(aes(fill = estimator), size = 2, position = position_dodge(width = 0.4)) +
  geom_point(aes(fill = estimator), shape = 21, size = 4, position = position_dodge(width = 0.4)) +
  scale_fill_manual("",
      values = c("white", "black", "gray"),
      label = c("Bayesian", "ML", "REML")) +
  coord_flip() +
  scale_x_discrete("") +
  scale_y_continuous("Point estimate and 95% confidence interval", breaks = c(-1, -0.5, 0, 0.5, 1)) +
  #scale_y_continuous("Point Estimate and 95% Confidence Interval", breaks = c(-1, -0.5, 0, 0.5, 1)) +
  theme_bw() +
    theme(panel.grid.minor = element_line(colour="white"),
    legend.justification= c(0, 0.8),
    legend.box = "vertical",
    legend.background = element_rect(fill=NA, color=NA),
    legend.key        = element_rect(fill =NA, color =NA),
    strip.background = element_rect(fill = "#f1f1f1", color = NA)) +
    theme(legend.position=c(0, 1)))

ggsave(filename = str_c(loc,"Figure5_color.pdf"), plot = plot, width = 7.5, height = 4.5)


