library("tidyverse")
library("ggplot2")
library("stringr")
library("readxl")
# library("xlsx")

# Define working directory
loc <- "YOURPATH/ReplicationFiles/Mplus-replication/"

# Read the data
mplus <- read_excel(str_c(loc,"Mplus_simresults.xlsx"))

# Some processing
mplus$link <- factor(mplus$link, labels = c("Linear Model", "Probit Model"))

mplus$type <- "Exact Stegmueller replicates"
mplus$type[mplus$replications == 10000] <- "10,000 Replications"
mplus$type[mplus$seed != 12345] <- "Random seeds"
mplus$type <- as.factor(mplus$type)

mplus$clusters[mplus$type == "10,000 Replications"] <- mplus$clusters[mplus$type == "10,000 Replications"] - 0.7
mplus$clusters[mplus$type == "Random seeds"] <- mplus$clusters[mplus$type == "Random seeds"] + 0.7

# 95% Monte Carlo CI
mplus$min95_b_z  <- mplus$b_z - qt(0.975, df = mplus$replications) * (mplus$sd_b_z / sqrt(mplus$replications))
mplus$max95_b_z  <- mplus$b_z + qt(0.975, df = mplus$replications) * (mplus$sd_b_z / sqrt(mplus$replications))

mplus$min95_b_x  <- mplus$b_x - qt(0.975, df = mplus$replications) * (mplus$sd_b_x / sqrt(mplus$replications))
mplus$max95_b_x  <- mplus$b_x + qt(0.975, df = mplus$replications) * (mplus$sd_b_x / sqrt(mplus$replications))

mplus$min95_b_zx <- mplus$b_zx - qt(0.975, df = mplus$replications) * (mplus$sd_b_zx / sqrt(mplus$replications))
mplus$max95_b_zx <- mplus$b_zx + qt(0.975, df = mplus$replications) * (mplus$sd_b_zx / sqrt(mplus$replications))

# Bias in %
mplus$bias_b_z        <- (mplus$b_z - 0.2) / 0.2 * 100
mplus$min95_bias_b_z  <- (mplus$min95_b_z - 0.2) / 0.2 * 100
mplus$max95_bias_b_z  <- (mplus$max95_b_z - 0.2) / 0.2 * 100

mplus$bias_b_x        <- (mplus$b_x - 0.25) / 0.25 * 100
mplus$min95_bias_b_x  <- (mplus$min95_b_x - 0.25) / 0.25 * 100
mplus$max95_bias_b_x  <- (mplus$max95_b_x - 0.25) / 0.25 * 100

mplus$bias_b_zx       <- (mplus$b_zx - 0.1) / 0.1 * 100
mplus$min95_bias_b_zx <- (mplus$min95_b_zx - 0.1) / 0.1 * 100
mplus$max95_bias_b_zx <- (mplus$max95_b_zx - 0.1) / 0.1 * 100

# Figure 1
# subset the data
plotdata <- mplus %>% filter(effect_type == "dce")
# Plot
plot <- ggplot(data = plotdata, aes(x = clusters, y = bias_b_z, ymin = min95_bias_b_z, max = max95_bias_b_z, shape = type, lty = type, color = type, lcolor = type)) +
  geom_hline(yintercept = 0, lty = 'solid', size = 0.4, color = "#000000") +
    geom_path() +
    geom_pointrange() +
    scale_shape_discrete("",
      solid = TRUE,
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_color_manual("",
      values = c("#545454", "black", "#a8a8a8"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_linetype_manual("",
      values = c("solid", "solid", "solid"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_x_continuous("Number of uppel-level units (e.g., countries)", breaks = c(5, 10, 15, 20, 25, 30)) +
    scale_y_continuous("Bias", breaks = c(-20, -15, -10, -5, 0, 5, 10, 15, 20), limits =c(-21, 21)) +
    facet_grid(. ~ link) +
    theme_bw() +
    theme(legend.justification= c(-2.7, 0),
    legend.box = "vertical",
    legend.background = element_rect(fill=NA, color=NA),
    legend.key        = element_rect(fill =NA, color =NA),
    strip.background = element_rect(fill = "#f1f1f1", color = NA)) +
    theme(legend.position=c(0, 0))
  print(plot)

# Save as pdf
ggsave(filename = str_c(loc,"Figure1_bw.pdf"), plot = plot, width = 8.3, height = 5)

plot <- ggplot(data = plotdata, aes(x = clusters, y = bias_b_z, ymin = min95_bias_b_z, max = max95_bias_b_z, shape = type, lty = type, color = type, lcolor = type)) +
  geom_hline(yintercept = 0, lty = 'solid', size = 0.4, color = "#FFA500") +
    geom_path() +
    geom_pointrange() +
    scale_shape_discrete("",
      solid = TRUE,
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_color_manual("",
      values = c("#545454", "black", "#a8a8a8"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_linetype_manual("",
      values = c("solid", "solid", "solid"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_x_continuous("Number of uppel-level units (e.g., countries)", breaks = c(5, 10, 15, 20, 25, 30)) +
    scale_y_continuous("Bias", breaks = c(-20, -15, -10, -5, 0, 5, 10, 15, 20), limits =c(-21, 21)) +
    facet_grid(. ~ link) +
    theme_bw() +
    theme(legend.justification= c(-2.7, 0),
    legend.box = "vertical",
    legend.background = element_rect(fill=NA, color=NA),
    legend.key        = element_rect(fill =NA, color =NA),
    strip.background = element_rect(fill = "#f1f1f1", color = NA)) +
    theme(legend.position=c(0, 0))
  print(plot)

# Save as pdf
ggsave(filename = str_c(loc,"Figure1_color.pdf"), plot = plot, width = 8.3, height = 5)

# Some processing
mplus$link <- factor(mplus$link, labels = c("Linear~Model", "Probit~Model"))

# Figure 2
# subset the data
plotdata            <- mplus %>% filter(effect_type == "cli")
# Reshape to long
plotdata1           <- plotdata %>% select(effect_type, link, clusters, type, bias_b_z, min95_bias_b_z, max95_bias_b_z)
colnames(plotdata1) <- c("effect_type", "link", "clusters", "type", "bias_b", "min95_bias_b", "max95_bias_b")
plotdata1$int_term   <- "z"

plotdata2           <- plotdata %>% select(effect_type, link, clusters, type, bias_b_x, min95_bias_b_x, max95_bias_b_x)
colnames(plotdata2) <- c("effect_type", "link", "clusters", "type", "bias_b", "min95_bias_b", "max95_bias_b")
plotdata2$int_term   <- "x"

plotdata3           <- plotdata %>% select(effect_type, link, clusters, type, bias_b_zx, min95_bias_b_zx, max95_bias_b_zx)
colnames(plotdata3) <- c("effect_type", "link", "clusters", "type", "bias_b", "min95_bias_b", "max95_bias_b")
plotdata3$int_term   <- "x:z"
plotdata            <- rbind(plotdata1, plotdata2, plotdata3)
plotdata$int_term <- factor(plotdata$int_term, labels = c("beta[x]", "beta[x*z]", "beta[z]"))

# Cut the 95 CI, because they are sometimes just too large
plotdata$min95_bias_b[plotdata$min95_bias_b < -21] <- -21
plotdata$max95_bias_b[plotdata$max95_bias_b > 21] <- 21

# Plot
plot <- ggplot(data = plotdata, aes(x = clusters, y = bias_b, ymin = min95_bias_b, max = max95_bias_b, shape = type, lty = type, color = type, lcolor = type)) +
  geom_hline(yintercept = 0, lty = 'solid', size = 0.4, color = "#000000") +
    geom_path() +
    geom_pointrange() +
    scale_shape_discrete("",
      solid = TRUE,
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_color_manual("",
      values = c("#545454", "black", "#a8a8a8"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_linetype_manual("",
      values = c("solid", "solid", "solid"),
      label = c("10,000 Replications", "Exact Stegmueller replicates", "Random seeds")) +
    scale_x_continuous("Number of uppel-level units (e.g., countries)", breaks = c(5, 10, 15, 20, 25, 30)) +
    scale_y_continuous("Bias", breaks = c(-20, -15, -10, -5, 0, 5, 10, 15, 20), limits =c(-21, 21)) +
    facet_grid(int_term ~ link, labeller = label_parsed) +
    theme_bw() +
    theme(legend.justification= c(-2.6, 0),
    legend.box = "vertical",
    legend.background = element_rect(fill=NA, color=NA),
    legend.key        = element_rect(fill =NA, color =NA),
    strip.background = element_rect(fill = "#f1f1f1", color = NA)) +
    theme(legend.position=c(0, 0))
  print(plot)

# Save as pdf
ggsave(filename = str_c(loc,"FigureB1.pdf"), plot = plot, width = 8.3, height = 10)

