## Clear workspace
rm(list = ls())

## Load libaries
library('Hmisc')
library('plyr')
library('popbio')
library('stringr')
library('reshape')
library('lme4')
library('lmerTest')
library('memisc')
library('mvtnorm')
library('foreign')
library('parallel')
library('car')
library('zoo')
library("SDMTools")
library('dplyr')
library('hglm')

# Set working directories
## Assuming that 'YOURPATH' is the directory where
## 'ReplicationFiles.zip' was unpacked.
loc <- "YOURPATH/ReplicationFiles/R_Coverage_Replication/"
## Assuming that R is run from the working directory is where the script is
## located
loc <- "../"

## Load the Master Function, data generator, and modeller
source(str_c(loc,"RJobs/sim_01a_MasterFunction.R"))
source(str_c(loc,"RJobs/sim_02_multidata.R"))
source(str_c(loc,"RJobs/sim_03_models.R"))

# Define lists for all experimental conditions
list.clusts   <- rep(c(5, 10, 15, 20, 25, 30), 14)
list.cli      <- rep(c(rep(F, 6), rep(T, 6)), 7)
list.probit   <- c(rep(T, 12), rep(F, 36), rep(T, 24), rep(F, 12))
list.icc      <- c(rep(10, 24), rep(rep(c(5, 10), each = 12), 2), rep(10, 12))
list.cdiff    <- c(rep(0, 72), rep(0.5, 12))
list.DFApprox <- c(rep(F, 12), rep(T, 12), rep(F, 48), rep(T, 12))

# A list of 84 5-digit random number seeds for the 84 experimental conditions
# (setting seed only once would be ideal, but does not allow breaking
# simulation work into pieces)
# List of seeds was obtained from random.org on 2018-12-14 11:37:34 UTC

list.seeds <- 
  c(60057, 72485, 55130, 76646, 77309,
    37665, 24272, 96774, 39747, 31090,
    26392, 19356, 37419, 34203, 62086,
    63258, 75729, 59556, 64883, 85516,
    55135, 96463, 79706, 38532, 69067,
    76498, 90287, 28622, 32921, 22665,
    31126, 32302, 63278, 14656, 52019,
    75657, 55284, 81496, 49166, 31560,
    76983, 98092, 76937, 15683, 32407,
    42794, 70873, 45754, 54833, 14346,
    46599, 98306, 90786, 28349, 80127,
    74043, 39405, 82216, 27517, 81714,
    98534, 74018, 34424, 74604, 83299,
    82058, 84810, 46017, 78827, 81156,
    62762, 90223, 51076, 47773, 51383,
    90621, 46534, 49025, 74584, 50798,
    26380, 51199, 81847, 59790)
# Verify that list of seeds contains no duplicates
length(unique(list.seeds))

# This loop repeatedly calls the MLMaster function,
# which (calling some further functions) simulates multilevel data,
# applies the estimators of interest to them, and saves the results

# To replicate all results for all experimental conditions used in the paper
# (some of which are only covered in the online appendix),
# the loop needs to run from 1 to 84 (random number seeds for 
# the experimental conditions are taken from the "list.seeds" object defined above
# and then set inside the MLMaster function)

# Simulating all 84 experimental conditions will take very long time
# even on powerful computers; you may want to simulate only a subset of
# conditions by changing "(i in 1:84)" to "(i in 1:12)", "(i in 8)", "(i in c(3, 58, 79))" etc.

# On multi-core computers, the MLMaster function paralellizes
# model estimation across "Ncores" cores if Ncores > 1

# The "reps" argument (number of replications) needs to be set to 5000
# to replicate the results in the paper

# The elements of the various "list.XYZ" vectors (all of length 84)
# define the various experimental conditions: "list.clusts" specifies
# the number of upper-level units or clusters, "list.cli" whether the
# data-generating process and model should include a cross-level interaction
# (and random slope) term, and so forth
# For an exact replication of the results reported in the paper, the order
# of the elements in these vectors (defined above) must not be changed

for (i in 1:84) {
  print(str_c("Condition ", i))
  MLMaster(condition = i, reps = 5000, Ncores = 2, loc = loc,
    seed = list.seeds[i], icc = list.icc[i], cli = list.cli[i],
    probit = list.probit[i], clusts = list.clusts[i], cdiff = list.cdiff[i],
  	DFApprox = list.DFApprox[i])
}


