convGetter <- function (x) {
  # For getting convergence info after mixed model estimation
  l <- length(x@optinfo$conv$lme4$messages)
  if (l == 0) {
    convmes <- c("|grad| OK", "Hessian OK") 
  }
  if (l == 1) {
    convmes <- c(x@optinfo$conv$lme4$messages[[1]], "Hessian OK") 
  }
  if (l == 2) {
    convmes <- c(x@optinfo$conv$lme4$messages[[1]], x@optinfo$conv$lme4$messages[[2]]) 
  }

  convmes
}

vcGetter <- function(mod, cli) {
  # Extract Variance components for wrong/simplistic mixed model
  vc <- VarCorr(mod)
  vcs <- attr(vc[[1]], 'stddev')
  vcs['resid'] <- attr(vc, 'sc')
  names(vcs)[names(vcs) == '(Intercept)'] <- 'cons'
  names(vcs) <- paste('sd.', names(vcs), sep = '')
  if (cli) {
    vcs['corr.cons.x'] <- attr(vc[[1]], 'correlation')['x', '(Intercept)']
  }
  vcs
}
